#include<stdio.h>
#include<string.h>
#include<glib-object.h>
#include"meson-sample.h"
#include"@ENUM_FILE@"

int main(int argc, char **argv) {
    GEnumClass *xenum = g_type_class_ref(MESON_TYPE_THE_XENUM);
    GFlagsClass *flags_enum = g_type_class_ref(MESON_TYPE_THE_FLAGS_ENUM);
    if (g_enum_get_value_by_name(xenum, "MESON_THE_XVALUE")->value != MESON_THE_XVALUE) {
        fprintf(stderr, "Get MESON_THE_XVALUE by name failed.\n");
        return 1;
    }
    if (g_enum_get_value_by_nick(xenum, "the-xvalue")->value != MESON_THE_XVALUE) {
        fprintf(stderr, "Get MESON_THE_XVALUE by nick failed.\n");
        return 2;
    }
    if (g_flags_get_value_by_name(flags_enum, "MESON_THE_FIRST_VALUE")->value != MESON_THE_FIRST_VALUE) {
        fprintf(stderr, "Get MESON_THE_FIRST_VALUE by name failed.\n");
        return 3;
    }
    if (g_flags_get_value_by_nick(flags_enum, "the-first-value")->value != MESON_THE_FIRST_VALUE) {
        fprintf(stderr, "Get MESON_THE_FIRST_VALUE by nick failed.\n");
        return 4;
    }
    g_type_class_unref(xenum);
    g_type_class_unref(flags_enum);
    fprintf(stderr, "All ok.\n");
    return 0;
}
